//* This program will read a rotary encoder connected to pins rb6 and rb7.

#include<16F877.H>							//Using the PIC 16F877
#device adc=10;								//Set ADC to 10 bit
#fuses HS,NOWDT,NOPROTECT,NOBROWNOUT,NOPUT	//Configuration Fuses
#use delay(clock=20000000)					//20Mhz Clock
#use rs232(baud=9600,xmit=PIN_c6,rcv=PIN_C7,PARITY=N,BITS=8)//Use RS-232
#org 0x1F00,0x1FFF{}                        //Reserve Memory for Bootloader

signed int16 current_position;


   static int old; 
   static int new; 
   static int value; 



#int_rb
void quad(void) { 
   //Here I have an edge on one of the quadrature inputs 
   new=input_b(); 
   value=new^old; 
   //'value', now has the bit set, which has changed 
   if (value & 0b01000000) { 
      //Here the low bit has changed 
      if (new & 0b01000000) { 
         //Here a rising edge on A 
         if (new & 0b10000000) --current_position; 
         else ++current_position; 
      } 
      else { 
         //Here a falling edge on A 
         if (new & 0b10000000) ++current_position; 
         else --current_position; 
      } 
   } 
   else { 
      //Here the high bit (B) must have changed 
      if (new & 0b10000000) { 
         //Here a rising edge on B 
         if (new & 0b01000000) ++current_position; 
         else --current_position; 
      } 
      else { 
         //Here a falling edge on B 
         if (new & 0b01000000) --current_position; 
         else ++current_position; 
      } 
   } 
   old=new; 
}

//***		Main Program	***//
void main() {
PORT_B_PULLUPS(True);
enable_interrupts(int_rb);
enable_interrupts(global);

puts("PIC16F877 - Up And Running @ 20 MHz\r\n"); //send OK message to serial port


old=input_b();

current_position = 0;

//***	Main Loop	***//
while(true){
	printf("Current Position = %5LD \r",current_position);	//Send position to serial port
//	delay_ms(100);
	}
}